#include <iostream>
#include <vector>
#include <math.h>
#include <string>

using namespace std;

typedef long long ll;
const ll INF = 1e9;

struct SegmentTree
{
	vector<pair<int, int>> v;
	int n;

	void build(vector<pair<int, int>>& a)
	{
		n = (1 << (int)ceil(log2(a.size())));
		v.assign(2*n - 1, {INF, INF});
		for (int i = 0; i < a.size(); i++) v[n - 1 + i] = a[i];
		for (int i = n - 2; i >= 0; i--) v[i] = min(v[2*i + 1], v[2*i + 2]);
	}

	pair<int, int> get(int left, int right)
	{
		return get(left, right, 0, 0, n);
	}

	pair<int, int> get(int left, int right, int ind, int l, int r)
	{
		if (l >= right || r <= left) return {INF, INF};
		if (l >= left && r <= right) return v[ind];
		int m = (r + l)/2;
		return min(get(left, right, 2*ind + 1, l, m), get(left, right, 2*ind + 2, m, r));
	}
};

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);
	int n, k;
	cin >> n >> k;
	string s;
	cin >> s;
	vector<int> b(n + 1);
	b[0] = 0;
	for (int i = 0; i < n; i++) b[i + 1] = b[i] + ((s[i] == '(')?1:-1);
	vector<pair<int, int>> a(n + 1);
	for (int i = 0; i <= n; i++) a[i] = {b[i], i};
	SegmentTree st;
	st.build(a);
	while(k--)
	{
		int left, right;
		cin >> left >> right;
		int d = b[left - 1] - b[right];
		int mn = st.get(left - 1, right + 1).second;
		if (d <= 0)
		{
			cout << -d + (mn - left + 1) << '\n';
			continue;
		}
		if (d >= b[left - 1] - b[mn])
		{
			cout << d << '\n';
			continue;
		}
		int h = b[mn] + d;
		int l = left - 1, r = mn + 1;
		while(r - l > 1)
		{
			int m = (r + l)/2;
			if (st.get(left - 1, m).first <= h) r = m;
			else l = m;
		}
		cout << d + (l - left + 1) << '\n';
	}
    return 0;
}
